#ifndef ZUNECALC_H
#define ZUNECALC_H

/*
**       $Filename: ZuneARC.h $
**       $Release: 1 $
**       $Revision: 1.2 $
**       $Date: 30/11/09 $
**
**       (C) Copyright 2009 Yannick Erb
**       All Rights Reserved
*/

/*----------------------------------------------------------------------------*/
/*    Includes & Defines                                                      */
/*----------------------------------------------------------------------------*/
                        
#include <stdio.h>                        /* standard C includes */ 
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include <exec/types.h>                   /* Amiga includes */
#include <utility/hooks.h>
#include <libraries/asl.h>
#include <libraries/mui.h>
#include <mui/NListview_mcc.h>
#include <libraries/coolimages.h>

#include <clib/alib_protos.h>             /* C prototypes */
#include <proto/exec.h>                   /* Amiga prototypes */
#include <proto/dos.h>
#include <proto/intuition.h>
#include <proto/muimaster.h>
#include <clib/intuition_protos.h>
#include <workbench/startup.h>

#define MAKEID(a,b,c,d) ((ULONG)(a)<<24|(ULONG)(b)<<16|(ULONG)(c)<<8|(ULONG)(d))

#define CREATE 50L
#define EXTSEL 51L                  /* constants for use in 'switch' statements */
#define EXTALL 52L                  /* and so on */
#define DELSEL 53L
#define ADDFIL 54L
#define OPENID 55L
#define NEWARC 60L
#define QUITSELADD 100L
#define SELADDOK   101L
#define SELADDDC   102L
#define SELADDPAR  103L
#define SELADDVOLL 105L
#define SELADDDIRL 106L


/*----------------------------------------------------------------------------*/
/*    Structures                                                              */
/*----------------------------------------------------------------------------*/
struct FileRecord
{
   char Name[256];
   char Size[16];
   char CSize[16];
   char Date[64];
};

struct Archivers
{
   char CmdName[10];
   char ExtractSingle[256];
   char ExtractAll[256];
   char ListContent[256];
   int  ContentHeader;
   int  ContentFooter;
   char ContentFmt[256];
   char PreAdd[256];
   char Add[256];
   char PostAdd[256];
   char PreRemove[256];
   char Remove[256];
   char PostRemove[256];
   char Create[256];
};

struct ArcTypes
{
   char Extension[10];
   int Archiver;
};

/*----------------------------------------------------------------------------*/
/*    Protos                                                                  */
/*----------------------------------------------------------------------------*/

int main(int, char **);
int ArchiveType(char *);
int readconf(void);
char *readconfline(char *);
void Runextcmd(char *,char *,char *,char *,char *,BOOL);
void ReadArchiveContent(char *);
char *CreateArchive();
void ExtractSelected(char *);
void ExtractAll(char *);
void RemoveSelected(char *);
void AddFile(char *);
char *getfilename(Object *, char *, BOOL, BOOL, char *, char *);
void AddInSelAddList(char *, char *, LONG);
static BOOL MakeMUIApp(void);
static APTR MakeButton(UBYTE *, UBYTE, UBYTE *);
AROS_UFP3(LONG, ListDispl,                      // List display Hook
  AROS_UFPA(struct Hook *, h, A0),
  AROS_UFPA(char **, array, A2),
  AROS_UFPA(struct FileRecord *, entry, A1));
AROS_UFP3(APTR, ListConst,                      // List construct Hook
  AROS_UFPA(struct Hook *, h, A0),
  AROS_UFPA(APTR, pool, A2),
  AROS_UFPA(struct FileRecord *, entry, A1));
AROS_UFP3(void, ListDest,                       // List destruct Hook
  AROS_UFPA(struct Hook *, h, A0),
  AROS_UFPA(APTR, pool, A2),
  AROS_UFPA(struct FileRecord *, entry, A1));
AROS_UFP3(LONG, VListDispl,                      // List display Hook
  AROS_UFPA(struct Hook *, h, A0),
  AROS_UFPA(char **, array, A2),
  AROS_UFPA(char *, entry, A1));
AROS_UFP3(APTR, VListConst,                      // List construct Hook
  AROS_UFPA(struct Hook *, h, A0),
  AROS_UFPA(APTR, pool, A2),
  AROS_UFPA(char *, entry, A1));
AROS_UFP3(void, VListDest,                       // List destruct Hook
  AROS_UFPA(struct Hook *, h, A0),
  AROS_UFPA(APTR, pool, A2),
  AROS_UFPA(char *, entry, A1));  
/*----------------------------------------------------------------------------*/
/*    Misc - global variables                                                 */
/*----------------------------------------------------------------------------*/

APTR App, Win, ArcList, ArcName, cmdtext;
APTR Button0, Button1, Button2, Button3, Button4, Button5;
APTR SelAdd, SelAdd_List, SelAdd_OK, SelAdd_CANCEL, 
     SelAdd_DirList, SelAdd_VolList, SelAdd_CD, SelAdd_PAR;

struct Library *MUIMasterBase;      /* pointer to the base of the library */
struct Archivers *archivers;        /* pointers to archivers descriptors  */
struct ArcTypes *arctypes;          /* pointers to archive type           */
int NbType,NbArc;
int ArcType;

#endif /* ZUNEARC_H */
