/*
**       $Filename: ZuneARC.c $
**       $Release: 1 $
**       $Revision: 1.3 $
**       $Date: 20/05/2010 $
**
**       (C) Copyright 2009, 2010 Yannick Erb
**       AROS Public License
*/

/*----------------------------------------------------------------------------*/
/*    Main include                                                            */
/*----------------------------------------------------------------------------*/

#include "ZuneARC.h"

/*----------------------------------------------------------------------------*/
/*    Menu                                                                    */
/*----------------------------------------------------------------------------*/

#define NMABOUT_ID 200L
#define NMCONF_ID 201L
struct NewMenu Menu[] =
{
   {NM_TITLE, "Project"           ,   0,0,0,(APTR)0},
   {NM_ITEM , "About..."          , "?",0,0,(APTR)NMABOUT_ID},
   {NM_ITEM , "Edit Configuration", "C",0,0,(APTR)NMCONF_ID},
   {NM_ITEM , NM_BARLABEL         ,   0,0,0,(APTR)0},
   {NM_ITEM , "QUIT"              , "Q",0,0,(APTR)MUIV_Application_ReturnID_Quit},
   {NM_END  , NULL                ,   0,0,0,(APTR)0},
};

/*----------------------------------------------------------------------------*/
/*    Main program                                                            */
/*----------------------------------------------------------------------------*/

int main(int argc, char **argv)
{

BOOL Running = TRUE;
ULONG Signals;
char *CurrentArcName;
   
   if (MUIMasterBase = OpenLibrary("muimaster.library", MUIMASTER_VMIN))
   {
      if (MakeMUIApp())
      {

         CurrentArcName = malloc(256+1);
         strncpy(CurrentArcName,"",256);
         set(Win, MUIA_Window_Open, TRUE);
         strncpy(CurrentArcName,"",256);
         
         set(Button2,MUIA_Disabled,TRUE);
         set(Button3,MUIA_Disabled,TRUE);
         set(Button4,MUIA_Disabled,TRUE);
         set(Button5,MUIA_Disabled,TRUE);
         
         // Read the configuration file 
         if (readconf())
         {
            MUI_Request(App,Win,0,"Error message","OK",
                        "Error in Configuration file",
                        TAG_DONE);            
            exit(1);
         }

         if (argc>1)
         {
            // started from Shell with an argument
            strcpy(CurrentArcName,argv[1]);
         }
         else if(argc == 0)
         {
            // started from WB
            struct WBStartup *wbmsg;
            struct WBArg *wbarg;

            wbmsg = (struct WBStartup *)argv;
            wbarg = wbmsg->sm_ArgList;
            
            wbarg++; // We only want to now the Name and Path of first parameter
            
            if ( (wbmsg->sm_NumArgs>1) && (wbarg->wa_Lock) && (*wbarg->wa_Name) )
            {
               NameFromLock(wbarg->wa_Lock,CurrentArcName,256);
               AddPart(CurrentArcName,wbarg->wa_Name,256);
            }
         }
         
         if (strcmp(CurrentArcName,"")!=0)
         {    
            set(ArcName,MUIA_Text_Contents,CurrentArcName);
            DoMethod(ArcList,MUIM_NList_Clear);
            if((ArcType = ArchiveType(CurrentArcName))<NbType)
            { 
               ReadArchiveContent(CurrentArcName);
               if (strncmp(archivers[arctypes[ArcType].Archiver].ExtractSingle,"#",1)==0)
                   set(Button2,MUIA_Disabled,TRUE);
               else set(Button2,MUIA_Disabled,FALSE);
               if (strncmp(archivers[arctypes[ArcType].Archiver].ExtractAll,"#",1)==0)
                   set(Button3,MUIA_Disabled,TRUE);
               else set(Button3,MUIA_Disabled,FALSE);
               if (strncmp(archivers[arctypes[ArcType].Archiver].Remove,"#",1)==0)
                   set(Button4,MUIA_Disabled,TRUE);
               else set(Button4,MUIA_Disabled,FALSE);                                          
               if (strncmp(archivers[arctypes[ArcType].Archiver].Add,"#",1)==0)
                   set(Button5,MUIA_Disabled,TRUE);
               else set(Button5,MUIA_Disabled,FALSE);
            }
            else
            {
               if (strcmp(CurrentArcName,"")!=0)
                  MUI_Request(App,Win,0,"Error message","OK",
                              strcat(CurrentArcName,"\nis not a known archive type"),
                              TAG_DONE);
               set(ArcName,MUIA_Text_Contents,"");
               set(Button2,MUIA_Disabled,TRUE);
               set(Button3,MUIA_Disabled,TRUE);
               set(Button4,MUIA_Disabled,TRUE);
               set(Button5,MUIA_Disabled,TRUE);
            }         
         }

         while (Running)
         {
            switch(DoMethod(App, MUIM_Application_Input, &Signals))
            {
               case MUIV_Application_ReturnID_Quit:
                  Running = FALSE;                          /* break the loop */
                  break;

               case NMCONF_ID:
                  Execute("SYS:Tools/Editor ZuneARC.cfg",NULL,NULL);
                  MUI_Request(App,Win,0,"Configuration file change","OK",
                              "In order to make the configuration change effective\nyou have to quit and restart ZuneARC",
                              TAG_DONE);                   
                  break;
                  
               case NMABOUT_ID:
                  MUI_Request(App,Win,0,"About...","OK",
                              "\33cZuneARC\nVersion 1.4\n\nYannick Erb\nJanuary 2014",
                              TAG_DONE);                  
                  break;
                  
               case EXTSEL:
                  ExtractSelected(CurrentArcName);
                  break;

               case EXTALL:
                  ExtractAll(CurrentArcName);
                  break;
               
               case DELSEL:
                  RemoveSelected(CurrentArcName);
                  DoMethod(ArcList,MUIM_NList_Clear);
                  ReadArchiveContent(CurrentArcName);
                  break;

               case ADDFIL:
                  AddFile(CurrentArcName);
                  DoMethod(ArcList,MUIM_NList_Clear);
                  ReadArchiveContent(CurrentArcName);
                  break;
                  
               case CREATE:              
                  strcpy(CurrentArcName,CreateArchive());
                  set(ArcName,MUIA_Text_Contents,CurrentArcName);
                  DoMethod(ArcList,MUIM_NList_Clear);
                  if((ArcType = ArchiveType(CurrentArcName))<NbType)
                  { 
                     ReadArchiveContent(CurrentArcName);
                     if (strncmp(archivers[arctypes[ArcType].Archiver].ExtractSingle,"#",1)==0)
                         set(Button2,MUIA_Disabled,TRUE);
                     else set(Button2,MUIA_Disabled,FALSE);
                     if (strncmp(archivers[arctypes[ArcType].Archiver].ExtractAll,"#",1)==0)
                         set(Button3,MUIA_Disabled,TRUE);
                     else set(Button3,MUIA_Disabled,FALSE);
                     if (strncmp(archivers[arctypes[ArcType].Archiver].Remove,"#",1)==0)
                         set(Button4,MUIA_Disabled,TRUE);
                     else set(Button4,MUIA_Disabled,FALSE);                                          
                     if (strncmp(archivers[arctypes[ArcType].Archiver].Add,"#",1)==0)
                         set(Button5,MUIA_Disabled,TRUE);
                     else set(Button5,MUIA_Disabled,FALSE);
                  }
                  else
                  {
                     if (strcmp(CurrentArcName,"")!=0)
                        MUI_Request(App,Win,0,"Error message","OK",
                                    strcat(CurrentArcName,"\nis not a known archive type"),
                                    TAG_DONE);
                     set(ArcName,MUIA_String_Contents,"");
                     set(Button2,MUIA_Disabled,TRUE);
                     set(Button3,MUIA_Disabled,TRUE);
                     set(Button4,MUIA_Disabled,TRUE);
                     set(Button5,MUIA_Disabled,TRUE);
                  }
                  break;
                  
               case OPENID:
                  strcpy(CurrentArcName,getfilename(Win,"Select Archive to Open",FALSE,FALSE,"#?","SYS:"));
                  set(ArcName,MUIA_Text_Contents,CurrentArcName);
                  DoMethod(ArcList,MUIM_NList_Clear);
                  if((ArcType = ArchiveType(CurrentArcName))<NbType)
                  { 
                     ReadArchiveContent(CurrentArcName);
                     if (strncmp(archivers[arctypes[ArcType].Archiver].ExtractSingle,"#",1)==0)
                         set(Button2,MUIA_Disabled,TRUE);
                     else set(Button2,MUIA_Disabled,FALSE);
                     if (strncmp(archivers[arctypes[ArcType].Archiver].ExtractAll,"#",1)==0)
                         set(Button3,MUIA_Disabled,TRUE);
                     else set(Button3,MUIA_Disabled,FALSE);
                     if (strncmp(archivers[arctypes[ArcType].Archiver].Remove,"#",1)==0)
                         set(Button4,MUIA_Disabled,TRUE);
                     else set(Button4,MUIA_Disabled,FALSE);                                          
                     if (strncmp(archivers[arctypes[ArcType].Archiver].Add,"#",1)==0)
                         set(Button5,MUIA_Disabled,TRUE);
                     else set(Button5,MUIA_Disabled,FALSE);
                  }
                  else
                  {
                     if (strcmp(CurrentArcName,"")!=0)
                        MUI_Request(App,Win,0,"Error message","OK",
                                    strcat(CurrentArcName,"\nis not a known archive type"),
                                    TAG_DONE);
                     set(ArcName,MUIA_Text_Contents,"");
                     set(Button2,MUIA_Disabled,TRUE);
                     set(Button3,MUIA_Disabled,TRUE);
                     set(Button4,MUIA_Disabled,TRUE);
                     set(Button5,MUIA_Disabled,TRUE);
                  }
                  break;
               
               default:
                  break; 
            }
            if (Running && Signals) Wait(Signals);
         }
         set(Win, MUIA_Window_Open, FALSE);

         MUI_DisposeObject(App);
      }
      CloseLibrary(MUIMasterBase);
   }
   return(0);
}      

/*----------------------------------------------------------------------------*/
/*    MakeMUIApp - creates the user interface                                 */
/*----------------------------------------------------------------------------*/

static BOOL MakeMUIApp(void)
{

static struct Hook ListConstructHook;
static struct Hook ListDestructHook;
static struct Hook ListDisplayHook;
static struct Hook VListConstructHook;
static struct Hook VListDestructHook;
static struct Hook VListDisplayHook;
ListConstructHook.h_Entry = (HOOKFUNC)ListConst;
ListDestructHook.h_Entry = (HOOKFUNC)ListDest;
ListDisplayHook.h_Entry = (HOOKFUNC)ListDispl;
VListConstructHook.h_Entry = (HOOKFUNC)VListConst;
VListDestructHook.h_Entry = (HOOKFUNC)VListDest;
VListDisplayHook.h_Entry = (HOOKFUNC)VListDispl;

   if (!(App = ApplicationObject,
      MUIA_Application_Title,       "ZuneARC",
      MUIA_Application_Version,     "$VER: ZuneARC 1.4 (31.01.14)",
      MUIA_Application_Copyright,   " 2009-2014 Yannick Erb",
      MUIA_Application_Author,      "Yannick Erb",
      MUIA_Application_Description, "Zune Archivers Front-End",
      MUIA_Application_Base,        "ZARCC",
      MUIA_Application_Menustrip,   MUI_MakeObject(MUIO_MenustripNM,Menu,0),

      SubWindow, Win = WindowObject,
         MUIA_Window_Title, "ZuneARC",
         MUIA_Window_ID, MAKEID('Z','A','R','C'),
         MUIA_Window_Width , MUIV_Window_Width_Screen(50),
         MUIA_Window_Height, MUIV_Window_Height_Screen(50),         

         WindowContents, VGroup,
            Child, HGroup, 
               MUIA_Group_Spacing, 20, 
               MUIA_Group_SameWidth, TRUE,
               Child, VGroup,
                  Child, Button0 = MakeButton("PROGDIR:Icons/Open.png", 'o', "\33uO\33npen Archive"),
                  Child, KeyLabel2("\33c\33uO\33npen",'\0'),
               End,            
               Child, VGroup,
                  Child, Button1 = MakeButton("PROGDIR:Icons/Create.png", 'c', "\33uC\33nreate New Archive"),
                  Child, KeyLabel2("\33c\33uC\33nreate New",'\0'),
               End,
               Child, VGroup,
                  Child, Button2 = MakeButton("PROGDIR:Icons/ExtractSel.png", 's',"Extract \33uS\33nelected"),
                  Child, KeyLabel2("\33cExtract \33uS\33nel.",'\0'),
               End,
                Child, VGroup,
                  Child, Button3 = MakeButton("PROGDIR:Icons/ExtractALL.png", 'e',"\33uE\33nxtract All"),
                  Child, KeyLabel2("\33c\33uE\33nxtract All",'\0'),
               End,
                Child, VGroup,
                  Child, Button4 = MakeButton("PROGDIR:Icons/Remove.png", 'r',"\33uR\33nemove files from archive"),
                  Child, KeyLabel2("\33c\33uR\33nemove Sel.",'\0'),
               End,
                Child,VGroup,
                  Child, Button5 = MakeButton("PROGDIR:Icons/Add.png", 'a',"\33uA\33ndd files to archive"),
                  Child, KeyLabel2("\33c\33uA\33ndd files",'\0'),
               End,        
               Child, RectangleObject, End,
            End,

            Child, BalanceObject, End,
          
            Child, HGroup, MUIA_Group_SameHeight, TRUE,  
               Child, KeyLabel2(" Archive :",'\0'),
               Child, ArcName = TextObject,
                         MUIA_Frame, MUIV_Frame_Text,
	       End,
            End,   
           
            Child, NListviewObject,      
               MUIA_NListview_NList, ArcList = NListObject,
                  MUIA_NList_MultiSelect, MUIV_NList_MultiSelect_Default,
                  MUIA_NList_ConstructHook, (IPTR)&ListConstructHook,
                  MUIA_NList_DestructHook, (IPTR)&ListDestructHook,
                  MUIA_NList_DisplayHook, (IPTR)&ListDisplayHook,
                  MUIA_NList_Format, "BAR,P=\33r BAR,P=\33r BAR,BAR",
                  MUIA_NList_Title, TRUE,
               End,
            End,

            Child, BalanceObject, End,
                        
            Child, cmdtext = GaugeObject,
                    MUIA_Gauge_Horiz, TRUE,
                    MUIA_FixHeightTxt, " ",
                    MUIA_Frame, MUIV_Frame_Gauge,
            End,
            
         End,
      End, 
      
      SubWindow, SelAdd = WindowObject,
         MUIA_Window_Title, "Select files to ADD",
         MUIA_Window_ID, MAKEID('Z','A','R','1'),
         MUIA_Window_Width , MUIV_Window_Width_Screen(50),
         MUIA_Window_Height, MUIV_Window_Height_Screen(50),         

         WindowContents, VGroup,
            Child, HGroup,
               Child, VGroup,
                  Child, HGroup,
                     Child, KeyLabel2("Base Directory :",'\0'),
                     Child, SelAdd_CD = TextObject,
                        MUIA_Frame, MUIV_Frame_Text,
                     End,   
                  End,
               
                  Child, HGroup,
                     Child, NListviewObject,
                        MUIA_Weight, 30,
                        MUIA_NListview_NList, SelAdd_VolList = NListObject,
                           MUIA_NList_ConstructHook, (IPTR)&VListConstructHook,
                           MUIA_NList_DestructHook, (IPTR)&VListDestructHook,
                           MUIA_NList_DisplayHook, (IPTR)&VListDisplayHook,
                           MUIA_Frame, MUIV_Frame_InputList,             
                        End,   
                     End,
                     Child, ListviewObject,
                        MUIA_Listview_List, SelAdd_DirList = DirlistObject,
                           MUIA_Dirlist_Directory, "",
                           MUIA_Dirlist_DrawersOnly, TRUE,
                           MUIA_Frame, MUIV_Frame_InputList,           
                        End,   
                     End,
                  End,
               End,   
             
               Child, NListviewObject,      
                  MUIA_NListview_NList, SelAdd_List = NListObject,
                     MUIA_NList_MultiSelect, MUIV_NList_MultiSelect_Default,
                     MUIA_NList_ConstructHook, (IPTR)&ListConstructHook,
                     MUIA_NList_DestructHook, (IPTR)&ListDestructHook,
                     MUIA_NList_DisplayHook, (IPTR)&ListDisplayHook,
                     MUIA_NList_Format, "COL=0 BAR,COL=1 P=\33r BAR,COL=3 BAR",
                     MUIA_NList_Title, TRUE,
                  End,
               End,
            End,   
            Child, HGroup, 
               MUIA_Group_Spacing, 50, 
               MUIA_Group_SameWidth, TRUE,
               Child, SelAdd_OK     = CoolImageIDButton("ARCHIVE",COOL_SAVEIMAGE_ID),
               Child, SelAdd_PAR    = CoolImageIDButton("PARENT",COOL_SWITCHIMAGE_ID),
               Child, SelAdd_CANCEL = CoolImageIDButton("CANCEL",COOL_CANCELIMAGE_ID),
            End,
         End,
      End, 
   End)) return(FALSE);

   /* the 'end program' flag */

   DoMethod(Win, MUIM_Notify, MUIA_Window_CloseRequest, TRUE,
      App, 2, MUIM_Application_ReturnID, MUIV_Application_ReturnID_Quit);
      
   /* Buttons that are handled by the main event loop */

   DoMethod(Button0, MUIM_Notify, MUIA_Pressed, FALSE,
      App, 2, MUIM_Application_ReturnID, OPENID);

   DoMethod(Button1, MUIM_Notify, MUIA_Pressed, FALSE,
      App, 2, MUIM_Application_ReturnID, CREATE);

   DoMethod(Button2, MUIM_Notify, MUIA_Pressed, FALSE,
      App, 2, MUIM_Application_ReturnID, EXTSEL);

   DoMethod(Button3, MUIM_Notify, MUIA_Pressed, FALSE,
      App, 2, MUIM_Application_ReturnID, EXTALL);

   DoMethod(Button4, MUIM_Notify, MUIA_Pressed, FALSE,
      App, 2, MUIM_Application_ReturnID, DELSEL);

   DoMethod(Button5, MUIM_Notify, MUIA_Pressed, FALSE,
      App, 2, MUIM_Application_ReturnID, ADDFIL);

   /* PopASL, archive changed event.*/

   DoMethod(ArcName, MUIM_Notify, MUIA_Popasl_Active, FALSE,
      App, 2, MUIM_Application_ReturnID, NEWARC);
   
   /* Events from the SelAdd window */
      
   DoMethod(SelAdd, MUIM_Notify, MUIA_Window_CloseRequest, TRUE,
      App, 2, MUIM_Application_ReturnID, QUITSELADD);
   
   DoMethod(SelAdd_CANCEL, MUIM_Notify, MUIA_Pressed, FALSE,
      App, 2, MUIM_Application_ReturnID, QUITSELADD);
      
   DoMethod(SelAdd_OK, MUIM_Notify, MUIA_Pressed, FALSE,
      App, 2, MUIM_Application_ReturnID, SELADDOK);

   DoMethod(SelAdd_List, MUIM_Notify, MUIA_Listview_DoubleClick, TRUE,
      App, 2, MUIM_Application_ReturnID, SELADDDC);

   DoMethod(SelAdd_VolList, MUIM_Notify, MUIA_Listview_DoubleClick, TRUE,
      App, 2, MUIM_Application_ReturnID, SELADDVOLL);
      
   DoMethod(SelAdd_DirList, MUIM_Notify, MUIA_Listview_DoubleClick, TRUE,
      App, 2, MUIM_Application_ReturnID, SELADDDIRL);            

   DoMethod(SelAdd_PAR, MUIM_Notify, MUIA_Pressed, FALSE,
      App, 2, MUIM_Application_ReturnID, SELADDPAR);
   return(TRUE);
}

/*----------------------------------------------------------------------------*/
/*    MakeButton                                                              */
/*----------------------------------------------------------------------------*/

static APTR MakeButton(UBYTE *Image, UBYTE Key, UBYTE *Help)
{
   return(MUI_NewObject("Dtpic.mui",
                        MUIA_Dtpic_Name,Image,
                        MUIA_InputMode, MUIV_InputMode_RelVerify,
                        MUIA_ControlChar, Key,
                        MUIA_Background, MUII_ButtonBack,
                        MUIA_ShortHelp, Help,
                        ImageButtonFrame,
                        TAG_DONE));
}

/*----------------------------------------------------------------------------*/
/*    List construct Hook                                                     */
/*----------------------------------------------------------------------------*/

AROS_UFH3(APTR, ListConst,
  AROS_UFHA(struct Hook *, h, A0),
  AROS_UFHA(APTR, pool, A2),
  AROS_UFHA(struct FileRecord *, entry, A1));
{
   AROS_USERFUNC_INIT
   
   struct FileRecord *new;
   if (new=AllocPooled(pool,sizeof(struct FileRecord))) 
   {
      *new = *entry;
   }      
   return(new);
   
   AROS_USERFUNC_EXIT
}
  
/*----------------------------------------------------------------------------*/
/*    List destruct Hook                                                      */
/*----------------------------------------------------------------------------*/  

AROS_UFH3(void, ListDest,
  AROS_UFHA(struct Hook *, h, A0),
  AROS_UFHA(APTR, pool, A2),
  AROS_UFHA(struct FileRecord *, entry, A1));
{
   AROS_USERFUNC_INIT
   
   FreePooled(pool, entry, sizeof(struct FileRecord));

   AROS_USERFUNC_EXIT
}

/*----------------------------------------------------------------------------*/
/*    List display Hook                                                       */
/*----------------------------------------------------------------------------*/  

AROS_UFH3(LONG, ListDispl,
  AROS_UFHA(struct Hook *, h, A0),
  AROS_UFHA(char **, array, A2),
  AROS_UFHA(struct FileRecord *, entry, A1))
{
   AROS_USERFUNC_INIT
   
   static char buf1[256],buf2[16],buf3[16],buf4[64];
   
   strcpy(buf1,"\33b");
   strcpy(buf2,"\33b");
   strcpy(buf3,"\33b");
   strcpy(buf4,"\33b");

   if(entry)
   {  
      if (strcmp(entry->Size,"DIR")==0)
      {
         *array++ = strcat(buf1,entry->Name);
         *array++ = strcat(buf2,entry->Size);
         *array++ = strcat(buf3,entry->CSize);
         *array   = strcat(buf4,entry->Date);
      }
      else
      {
         *array++ = entry->Name;
         *array++ = entry->Size;
         *array++ = entry->CSize;
         *array   = entry->Date;
      }
   }
   else
   {
      *array++ = "Name";
      *array++ = "File Size";
      *array++ = "Arch Size";
      *array   = "Date";
   }

   return(0);
   
   AROS_USERFUNC_EXIT
}

/*----------------------------------------------------------------------------*/
/*    VList construct Hook                                                    */
/*----------------------------------------------------------------------------*/

AROS_UFH3(APTR, VListConst,
  AROS_UFHA(struct Hook *, h, A0),
  AROS_UFHA(APTR, pool, A2),
  AROS_UFHA(char *, entry, A1));
{
   AROS_USERFUNC_INIT
   
   char *new;
   if (new=AllocPooled(pool,32)) 
   {
      strcpy(new,entry);
   }      
   return(new);
   
   AROS_USERFUNC_EXIT
}
  
/*----------------------------------------------------------------------------*/
/*    VList destruct Hook                                                     */
/*----------------------------------------------------------------------------*/  

AROS_UFH3(void, VListDest,
  AROS_UFHA(struct Hook *, h, A0),
  AROS_UFHA(APTR, pool, A2),
  AROS_UFHA(char *, entry, A1));
{
   AROS_USERFUNC_INIT
   
   FreePooled(pool, entry, 32);

   AROS_USERFUNC_EXIT
}

/*----------------------------------------------------------------------------*/
/*    VList display Hook                                                      */
/*----------------------------------------------------------------------------*/  

AROS_UFH3(LONG, VListDispl,
  AROS_UFHA(struct Hook *, h, A0),
  AROS_UFHA(char **, array, A2),
  AROS_UFHA(char *, entry, A1))
{
   AROS_USERFUNC_INIT

   if (entry)
   {      
      strcpy(*array,entry);
   }
   else
   {
      *array   = "Volume";
   }

   return(0);
   
   AROS_USERFUNC_EXIT
}

/*----------------------------------------------------------------------------*/
/*    int ArchiveType(char *ArcFile)                                          */
/*    Returns the Archive type of the file              		      */
/*----------------------------------------------------------------------------*/  

int ArchiveType(char *ArcFile)
{
   int extlen, i, type = 0;
   
   while(type<NbType) 
   {
     extlen = strlen(arctypes[type].Extension);
     for(i=0;i<extlen;i++)
     {
        if (toupper(arctypes[type].Extension[i])!=toupper(ArcFile[strlen(ArcFile)-extlen+i])) break;
     }
     if (i==extlen) break;
     type++;
   }
   
   return(type);
}

/*----------------------------------------------------------------------------*/
/*    ReadArchiveContent(char *ArcFile)                                       */
/*    Reads the archive content and display it in the List		      */
/*----------------------------------------------------------------------------*/

void ReadArchiveContent(char *ArcFile)
{
   struct FileRecord rec;
   FILE *cf;
   char line[1024];
   char CurrentReading[512];
   int EntryType[30];
   int EntryMSpa[30];
   int NbLine = 0,CurrentLine = 0, NbEntriesContentLine = 0, i = 0, j = 0, k = 0;
   
   // clear display list
   DoMethod(ArcList,MUIM_NList_Clear);
   
   // generate tmp file containing the entries list
   Runextcmd(archivers[arctypes[ArcType].Archiver].ListContent,ArcFile,"","","",TRUE);
   
   // decode ContentFmt from config file (only first letter is kept)
   while(archivers[arctypes[ArcType].Archiver].ContentFmt[i] != '\0')
   {
      if(archivers[arctypes[ArcType].Archiver].ContentFmt[i++] == ' ')
      {
        EntryType[NbEntriesContentLine] = (int)archivers[arctypes[ArcType].Archiver].ContentFmt[i-5];
		EntryMSpa[NbEntriesContentLine] = atoi(&archivers[arctypes[ArcType].Archiver].ContentFmt[i-3]);
        NbEntriesContentLine++;
      }
   }   
   EntryType[NbEntriesContentLine] = (int)archivers[arctypes[ArcType].Archiver].ContentFmt[i-4];
   EntryMSpa[NbEntriesContentLine] = atoi(&archivers[arctypes[ArcType].Archiver].ContentFmt[i-2]);       
   
   // decode tmp file
   if((cf = fopen("T:ZuneARC.tmp","r"))!=NULL)
   {
      // count total number of line in file
      while(fgets(line,512,cf)!=NULL) NbLine++;
      rewind(cf);
	  
      while(fgets(line,512,cf)!=NULL)
      {
         CurrentLine++;
		 
         if((CurrentLine > archivers[arctypes[ArcType].Archiver].ContentHeader) // skip header
            && (CurrentLine < NbLine-archivers[arctypes[ArcType].Archiver].ContentFooter+1)) // and footer
         {
         
            strcpy(rec.Name,"");
            strcpy(rec.Size,"");
            strcpy(rec.CSize,"");
            strcpy(rec.Date,"");
            
            // Read entries
            j = 0;
            for(i=0;i<NbEntriesContentLine+1;i++)
            {
               k = 0;
			   // skip initial spaces and tabs
               while(line[j]==' ' || line[j]=='\t')
			   {
			     j++;
				 k++;
			   }
			   // if number of spaces (k) is bigger than the maximum allowed consecutive spaces than we're jumping to next entry
			   if (EntryMSpa[i] > 0 && k > EntryMSpa[i]) i++;			   
			   k = 0;
			   // read entry till space or tab or EOL encountered
               while(line[j]!=' ' && line[j]!='\t' && line[j]!='\0' && line[j]!='\n')
               {
                  CurrentReading[k++] = line[j++];
               }
               CurrentReading[k] = '\0';
                
               switch(EntryType[i])
               {
                  case 'N':
                     if(strcmp(rec.Name,"")!=0) strcat(rec.Name," ");
                     strcpy(rec.Name,strcat(rec.Name,CurrentReading));
                     break;

                  case 'C':
                     strcat(rec.CSize,CurrentReading);
                     break;
                     
                  case 'S':
                     strcat(rec.Size,CurrentReading);
                     break;
                     
                  case 'D':
                     if(strcmp(rec.Date,"")!=0) strcat(rec.Date," ");
                     strcat(rec.Date,CurrentReading);
                     break;

                  default:
                     break;
               }
            }
            if ((atoi(rec.Size)==0) && (rec.Name[strlen(rec.Name)-1]=='/')) 
            {
               strcpy(rec.Size,"DIR");
            }                   
            DoMethod(ArcList,MUIM_NList_InsertSingle,(IPTR)&rec, MUIV_NList_Insert_Bottom); 
         }
      }   
      fclose(cf);
      //DeleteFile("T:ZuneARC.tmp");
   }
   else
   {
      MUI_Request(App,Win,0,"Error message","OK",
         "Temporary file was not created\nthere is either an error in the archive\nor in configuration file.",
         TAG_DONE);
   }
}


/*-------------------------------------------------------------------------------------*/
/*    void Runextcmd(char * fmt,char *arch,char *file,char *dest, char *base,BOOL out) */
/*    Formats and run the external command string                     	               */
/*-------------------------------------------------------------------------------------*/

void Runextcmd(char * fmt,char *arch,char *file,char *dest, char *base, BOOL out)
{
   char cmd[1024];
   char tmp[512];
   char display[1024];
   int i = 0,j = 0;
   FILE *sf;
   
   strncpy(display,"\0332",1024);
   strncpy(cmd,"",1024);
   strncpy(tmp,"",512);
   
   sf = fopen("T:ZuneARC.script","w");
   
   while (fmt[i]!='\0')
   {
      if(fmt[i]==';')  // Command Section finished
      {
         i++;
         cmd[j] = '\0';
         if(out) strcat(cmd," >T:ZuneARC.tmp");
         //printf("%s\n",cmd);         
         fprintf(sf,"%s\n",cmd);
         j = 0;
         strncpy(cmd,"",512);
      }
      if(fmt[i]!='%') 
      {
         cmd[j++] = fmt[i++];
      }
      else
      {  
         if (fmt[i+1]=='%') i++;
            else strcpy(tmp,"\"");
         if(strncmp(&fmt[i],"%arch",5)==0) strcat(tmp,arch);
         if(strncmp(&fmt[i],"%file",5)==0) strcat(tmp,file);
         if(strncmp(&fmt[i],"%dest",5)==0) strcat(tmp,dest);
         if(strncmp(&fmt[i],"%base",5)==0) strcat(tmp,base);
         if (fmt[i-1]!='%') strcat(tmp,"\"");
          
         strcat(cmd,tmp);
         j = j+strlen(tmp);
         i = i+5;        
      }         
   }
   cmd[j]='\0';
   if(out) strcat(cmd," >T:ZuneARC.tmp");
   //printf("%s\n",cmd);     
   fprintf(sf,"%s\n",cmd);
   fclose(sf);
   
   set(cmdtext,MUIA_Gauge_InfoText,strcat(display,cmd));
   BPTR scriptfile = Open("T:ZuneARC.script",MODE_OLDFILE);

   struct TagItem tags[] = {
   	                   {SYS_Input, (IPTR)NULL},
   	                   {SYS_Output, (IPTR)NULL},
   	                   {SYS_Error, (IPTR)NULL},
                       	   {SYS_ScriptInput, (IPTR)scriptfile},
   	                   {SYS_UserShell, TRUE},
   	                   {TAG_DONE, 0}
                           };
   
   SystemTagList("",tags);

   
}


/*----------------------------------------------------------------------------*/
/*    int readconf(void)                                                      */
/*    Reads the configuration file and store the information		      */
/*----------------------------------------------------------------------------*/

int readconf(void)
{
   FILE *cf;
   char line[256];
   char tmparc[10];
   int i,j,k,l;
   
   NbArc = 0;
   NbType = 0;   
   
   if((cf=fopen("PROGDIR:ZuneARC.cfg","r")) == NULL)
   {
      MUI_Request(App,Win,0,"Error message","OK",
                  "Can't open configuration file\nZuneARC.cfg shall be placed in\nsame directpry as ZuneARC.",
                  TAG_DONE);
   }
   else
   {
      while(fgets(line,128,cf)!=NULL)
      {
         if(strncmp(line,"CmdName",7)==0) NbArc++;
         if(strncmp(line,"ArcType",7)==0) NbType++;
      }
   }

   archivers = malloc(NbArc * sizeof(struct Archivers));
   arctypes = malloc(NbType * sizeof(struct ArcTypes));
   
   rewind(cf);
   
   j = 0;
   while(fgets(line,256,cf)!=NULL)
   {
      if(strncmp(line,"CmdName",7)==0)
      {
         j++;
         strcpy(archivers[j-1].CmdName,readconfline(line));
      }
      if(strncmp(line,"ExtractSingle",13)==0)
         strcpy(archivers[j-1].ExtractSingle,readconfline(line));
      if(strncmp(line,"ExtractAll",10)==0)
         strcpy(archivers[j-1].ExtractAll,readconfline(line));
      if(strncmp(line,"ListContent",11)==0)
         strcpy(archivers[j-1].ListContent,readconfline(line));
      if(strncmp(line,"ContentHeader",13)==0)
         archivers[j-1].ContentHeader=atoi(readconfline(line));
      if(strncmp(line,"ContentFooter",13)==0)
         archivers[j-1].ContentFooter=atoi(readconfline(line));
      if(strncmp(line,"ContentFmt",10)==0)
         strcpy(archivers[j-1].ContentFmt,readconfline(line));
      if(strncmp(line,"PreAdd",6)==0)
         strcpy(archivers[j-1].PreAdd,readconfline(line));
      if(strncmp(line,"Add",3)==0)
         strcpy(archivers[j-1].Add,readconfline(line));
      if(strncmp(line,"PostAdd",7)==0)
         strcpy(archivers[j-1].PostAdd,readconfline(line));
      if(strncmp(line,"PreRemove",9)==0)
         strcpy(archivers[j-1].PreRemove,readconfline(line));
      if(strncmp(line,"Remove",6)==0)
         strcpy(archivers[j-1].Remove,readconfline(line));
      if(strncmp(line,"PostRemove",10)==0)
         strcpy(archivers[j-1].PostRemove,readconfline(line));
	  if(strncmp(line,"Create",6)==0)
         strcpy(archivers[j-1].Create,readconfline(line));
   }

   rewind(cf);
   
   j = 0;
   while(fgets(line,256,cf)!=NULL)
   {
      if(strncmp(line,"ArcType",7)==0)
      {
         i = 0;
         k = 0;
         while(line[i++]!=',');
         while(line[i++]==' ');
         i--;
         while(line[i++]!=',') arctypes[j].Extension[k++]=line[i-1];
         arctypes[j].Extension[k] = '\0';
         while(line[i++]==' ');
         i--;
         k = 0;
         while(line[i++]!=',') tmparc[k++]=line[i-1];
         tmparc[k] = '\0';
         l = 0;
         while((strcmp(tmparc,archivers[l].CmdName)!=0) && (l<NbArc)) l++; 
         arctypes[j].Archiver = l;
         j++;                 
      }
   }
   
   fclose(cf);
   return(0);
}

/*----------------------------------------------------------------------------*/
/*    char *readconfline(char *line)                                          */
/*    Reads one configuration file and sends back the content 		      */
/*----------------------------------------------------------------------------*/

char *readconfline(char *line)
{
   static char info[256];
   int i = 0;
   int k = 0;

   while(line[i++]!=',');
   while(line[i++]==' ');
   i--;
   while(line[i++]!=',') info[k++]=line[i-1];
   info[k] = '\0';
   
   return info;
}               


/*----------------------------------------------------------------------------*/
/*    char *CreateArchive()                                                   */
/*    Creates a new archive file                             		      */
/*----------------------------------------------------------------------------*/
char *CreateArchive()
{
   char *FileToAdd;
   static char ArcName[128];
   char *res = NULL;
   char filter[16] = "#?.";
   int extlen;
   char arcsel[128]="";
   int i,j = 0;
   int TmpArcType[16];
   
   strncpy(ArcName,"",128);
   res = ArcName;
   
   for(i=0;i<NbType;i++)
   {
      if(archivers[arctypes[i].Archiver].Create[0]!='#')
      {
         if (arcsel[0]!='\0') strcat(arcsel,"|");
         strcat(arcsel,arctypes[i].Extension);
         TmpArcType[j++] = i;
      }
   }   

   
   strcat(arcsel,"|CANCEL");
   i = MUI_Request(App,Win,0,"Archive Type Selection",arcsel,
       "Select the type of archive you want to create",
       TAG_DONE);
   
   if(i)
   {
      ArcType = TmpArcType[i-1];        
      extlen = strlen(arctypes[ArcType].Extension);
      strcat(filter,arctypes[ArcType].Extension);

      strcpy(ArcName,getfilename(Win,"New Archive Name",FALSE,FALSE,filter,"SYS:"));
      // Append Extension if forgotten
      if (strcmp(ArcName,"")!=0)
      {
         if (strcmp(arctypes[ArcType].Extension,&ArcName[strlen(ArcName)-extlen])!=0)
         {
            strcat(ArcName,".");
            strcat(ArcName,arctypes[ArcType].Extension);
         }
   
         Runextcmd(archivers[arctypes[ArcType].Archiver].Create,ArcName,"","","",FALSE);
         res = ArcName;
      }   
   }      
   return(res);
}


/*----------------------------------------------------------------------------*/
/*    void ExtractSelected(char *Archive)                                     */
/*    Extract Selected files from archive                    		      */
/*----------------------------------------------------------------------------*/
void ExtractSelected(char *Archive)
{
   struct FileRecord *CurrentEntry;
   LONG id = MUIV_NList_NextSelected_Start;
   char *Destination;
      
   Destination = getfilename(Win,"Select Destination directory",FALSE,TRUE,"#?",Archive);
   
   if(strcmp(Destination,"")!=0)
   {
      for(;;)
      {
         DoMethod(ArcList,MUIM_NList_NextSelected,&id);
         if(id==MUIV_NList_NextSelected_End) break;
         
         DoMethod(ArcList,MUIM_NList_GetEntry,id,&CurrentEntry);
         
         Runextcmd(archivers[arctypes[ArcType].Archiver].ExtractSingle,
                   Archive,CurrentEntry->Name,
                   Destination,"",FALSE);
      }
   }
   else
   {
      MUI_Request(App,Win,0,"Error message","OK","No destination selected",TAG_DONE);
   }
}


/*----------------------------------------------------------------------------*/
/*    void ExtractAll(char *Archive)                                          */
/*    Extract All files from current Archive                  		      */
/*----------------------------------------------------------------------------*/
void ExtractAll(char *Archive)
{
   char *Destination;
      
   Destination = getfilename(Win,"Select Destination directory",FALSE,TRUE,"#?",Archive);
   
   if(strcmp(Destination,"")!=0)
   {
      Runextcmd(archivers[arctypes[ArcType].Archiver].ExtractAll,
                Archive,"",Destination,"",FALSE);
   }
   else
   {
      MUI_Request(App,Win,0,"Error message","OK","No destination selected",TAG_DONE);
   }
}


/*----------------------------------------------------------------------------*/
/*    void RemoveSelected(char *Archive)                                      */
/*    Delete Selected files from Archive                    		      */
/*----------------------------------------------------------------------------*/
void RemoveSelected(char *Archive)
{
   struct FileRecord *CurrentEntry;
   LONG id = MUIV_NList_NextSelected_Start;
   int Nselect = 0,x = 0; 
   
   if(strcmp(Archive,"")!=0)
   {
      for(;;)
      {
         set(cmdtext,MUIA_Gauge_Current,++x);
         DoMethod(ArcList,MUIM_NList_NextSelected,&id);
         if(id==MUIV_NList_NextSelected_End) break;
         Nselect++;
      }
      id = MUIV_NList_NextSelected_Start;
      set(cmdtext,MUIA_Gauge_Max,Nselect);
      // Remove pre command
      if (strlen(archivers[arctypes[ArcType].Archiver].PreRemove)>0)
         Runextcmd(archivers[arctypes[ArcType].Archiver].PreRemove,
                   Archive,"","","",FALSE);
      // Remove command (loop)
      for(;;)
      {
         set(cmdtext,MUIA_Gauge_Current,++x);
         DoMethod(ArcList,MUIM_NList_NextSelected,&id);
         if(id==MUIV_NList_NextSelected_End) break;
         
         DoMethod(ArcList,MUIM_NList_GetEntry,id,&CurrentEntry);
         
         Runextcmd(archivers[arctypes[ArcType].Archiver].Remove,
                   Archive,CurrentEntry->Name,"","",FALSE);
      }
      // Remove post command
      if (strlen(archivers[arctypes[ArcType].Archiver].PostRemove)>0)
         Runextcmd(archivers[arctypes[ArcType].Archiver].PostRemove,
                Archive,"","","",FALSE); 
      set(cmdtext,MUIA_Gauge_Current,0);
   }
   else
   {
      MUI_Request(App,Win,0,"Error message","OK","No archive selected",TAG_DONE);
   }
}


/*----------------------------------------------------------------------------*/
/*    void AddFile(char *Archive)                                             */
/*    Add files to current Archive                       		      */
/*----------------------------------------------------------------------------*/
void AddFile(char *Archive)
{   
   static char Base[128] = "SYS:";
   char vol[32];
   char *tmp;
   char test[32];
   BOOL Running = TRUE;
   ULONG Signals;
   struct FileRecord *CurrentEntry;
   LONG id = MUIV_NList_NextSelected_Start;
   int Nselect = 0,x,y;
   struct DosList *dl, *dlist;
   int i;
   
   #define MAX(a,b) (a)>(b)?(a):(b)
   
   // Get list of Volumes and file in VolList
   DoMethod(SelAdd_VolList, MUIM_List_Clear);
    dl = LockDosList(LDF_READ | LDF_VOLUMES | LDF_ASSIGNS);
    
    dlist = dl;
    while ((dlist = NextDosEntry(dlist, LDF_ASSIGNS)) != NULL)
    {
        if (dlist->dol_Name)
        {
            char *name = AROS_BSTR_ADDR(dlist->dol_Name);
            ULONG len = MAX(127, AROS_BSTR_strlen(dlist->dol_Name));

            for (i=0; i<len; i++)
                vol[i] = name[i];
            vol[len] = '\0';
            strcat(vol,":");
            DoMethod(SelAdd_VolList,MUIM_List_InsertSingle, vol, MUIV_List_Insert_Bottom);
        }
    }
    dlist = dl;
    while ((dlist = NextDosEntry(dlist, LDF_VOLUMES)) != NULL)
    {
        if (dlist->dol_Name)
        {
            char *name = AROS_BSTR_ADDR(dlist->dol_Name);
            ULONG len = MAX(127, AROS_BSTR_strlen(dlist->dol_Name));

            for (i=0; i<len; i++)
                vol[i] = name[i];
            vol[len] = '\0';
            strcat(vol,":");
            DoMethod(SelAdd_VolList,MUIM_List_InsertSingle, vol, MUIV_List_Insert_Bottom);
        }
    }
    
    UnLockDosList(LDF_READ | LDF_VOLUMES | LDF_ASSIGNS);
   
   set(SelAdd_DirList,MUIA_Dirlist_Directory,Base);
   set(SelAdd_CD,MUIA_Text_Contents,Base);   
   DoMethod(SelAdd_List,MUIM_NList_Clear);
   AddInSelAddList(Base,"",MUIV_NList_Insert_Sorted);
             
   set(SelAdd, MUIA_Window_Open, TRUE);
   
   while (Running)
   {
      switch(DoMethod(App, MUIM_Application_Input, &Signals))
      {
         case QUITSELADD:
            Running = FALSE;                          /* break the loop */
            set(SelAdd, MUIA_Window_Open, FALSE);
            break;
            
         case SELADDVOLL:
            DoMethod(SelAdd_VolList,MUIM_List_GetEntry,MUIV_List_GetEntry_Active,&tmp);
            sprintf(Base,"%s",tmp);            
            set(SelAdd_DirList,MUIA_List_Quiet,TRUE);
            set(SelAdd_DirList,MUIA_Dirlist_Directory,Base);
            set(SelAdd_DirList,MUIA_List_Quiet,FALSE);
            set(SelAdd_CD,MUIA_Text_Contents,Base);   
            DoMethod(SelAdd_List,MUIM_NList_Clear);
            AddInSelAddList(Base,"",MUIV_NList_Insert_Sorted);            
            break;
            
         case SELADDPAR:
            x=0;
            y=0;
            while(Base[x++]!='\0') if((Base[x]=='/') || (Base[x]==':')) y=x;
            if (Base[y]=='/') Base[y]='\0';
            if (Base[y]==':') Base[y+1]='\0';
            set(SelAdd_DirList,MUIA_List_Quiet,TRUE);
            set(SelAdd_DirList,MUIA_Dirlist_Directory,Base);
            set(SelAdd_DirList,MUIA_List_Quiet,FALSE);
            set(SelAdd_CD,MUIA_Text_Contents,Base);   
            DoMethod(SelAdd_List,MUIM_NList_Clear);
            AddInSelAddList(Base,"",MUIV_NList_Insert_Sorted);            
            break;
         
         case SELADDDIRL:
            strcpy(tmp,"");
            strcpy(tmp,(APTR)XGET(SelAdd_DirList,MUIA_Dirlist_Path));
            if (tmp) strcpy(Base,tmp);
            set(SelAdd_DirList,MUIA_List_Quiet,TRUE);
            set(SelAdd_DirList,MUIA_Dirlist_Directory,Base);
            set(SelAdd_DirList,MUIA_List_Quiet,FALSE);
            set(SelAdd_CD,MUIA_Text_Contents,Base);   
            DoMethod(SelAdd_List,MUIM_NList_Clear);
            AddInSelAddList(Base,"",MUIV_NList_Insert_Sorted);            
            break;
         
         case SELADDOK:
            x = 0;
            set(SelAdd, MUIA_Window_Open, FALSE);
            for(;;)
            {
               set(cmdtext,MUIA_Gauge_Current,++x);
               DoMethod(SelAdd_List,MUIM_NList_NextSelected,&id);
               if(id==MUIV_NList_NextSelected_End) break;
               Nselect++;
            }
            id = MUIV_NList_NextSelected_Start;
            set(cmdtext,MUIA_Gauge_Max,Nselect);
            // Add pre command
            if (strlen(archivers[arctypes[ArcType].Archiver].PreAdd)>0)
               Runextcmd(archivers[arctypes[ArcType].Archiver].PreAdd,
                         Archive,"","",Base,FALSE);
            // Add command (loop)
            for(;;)
            {
               set(cmdtext,MUIA_Gauge_Current,++x);
               DoMethod(SelAdd_List,MUIM_NList_NextSelected,&id);
               if(id==MUIV_NList_NextSelected_End) break;
         
               DoMethod(SelAdd_List,MUIM_NList_GetEntry,id,&CurrentEntry);
         
               Runextcmd(archivers[arctypes[ArcType].Archiver].Add,
                         Archive,CurrentEntry->Name,"",Base,FALSE);
            }
            // Add post command
            if (strlen(archivers[arctypes[ArcType].Archiver].PostAdd)>0)
            Runextcmd(archivers[arctypes[ArcType].Archiver].PostAdd,
                      Archive,"","",Base,FALSE); 
                                 
            set(cmdtext,MUIA_Gauge_Current,0);
            Running = FALSE;
            break;
            
         case SELADDDC:                               /* Double click on an entry */
            /*Get the active entry*/
            DoMethod(SelAdd_List,MUIM_NList_GetEntry,MUIV_NList_GetEntry_Active,&CurrentEntry);  
            /*If active entry is a directory explode it*/
            if (strncmp(CurrentEntry->Size,"DIR",3)==0)
            {               
               char Dir[128];
               char Path[128];
               if(Base[(strlen(Base)-1)]==':')sprintf(Dir,"%s%s",Base,CurrentEntry->Name);
                  else sprintf(Dir,"%s/%s",Base,CurrentEntry->Name);
               sprintf(Path,"%s/",CurrentEntry->Name);
               AddInSelAddList(Dir,Path,MUIV_NList_Insert_Sorted);
               DoMethod(SelAdd_List,MUIM_NList_Remove,MUIV_NList_Remove_Active);
	    }
	    break;
               
      }
      if (Running && Signals) Wait(Signals);
   }
   
}


/*----------------------------------------------------------------------------*/
/*    void AddInSelAddList(char *Dir,char *Path, LONG Position)               */
/*    Add files from DIR to Add List including Path in front of File Name     */
/*----------------------------------------------------------------------------*/
void AddInSelAddList(char *Dir, char *Path, LONG Position)
{
   BPTR BaseDirLock;
   struct FileInfoBlock *fib;
   BOOL success = FALSE;
   struct DateTime dt;
   char datebuffer[LEN_DATSTRING];
   char timebuffer[LEN_DATSTRING];
   struct FileRecord rec;
   
   set(SelAdd_List,MUIA_NList_Quiet,TRUE);
   BaseDirLock = Lock(Dir,ACCESS_READ);
   if (BaseDirLock)
   {
      fib = AllocDosObject(DOS_FIB, NULL);
      if (fib)
      {
         success = Examine(BaseDirLock, fib);
         if (success && fib->fib_DirEntryType > 0)
         {
            for (;;)
            {
               BOOL ok;
            
               ok = ExNext(BaseDirLock,fib);
               if (!ok)
               {
                  if (IoErr() == ERROR_NO_MORE_ENTRIES) break;
                  success = FALSE;
                  continue;
               }
            
               dt.dat_Stamp = fib->fib_Date;
               dt.dat_Format = FORMAT_DOS;
               dt.dat_Flags = 0;
               dt.dat_StrDay = NULL;
               dt.dat_StrDate = datebuffer;
               dt.dat_StrTime = timebuffer;
            
               DateToStr(&dt);
            
               sprintf(rec.Name,"%s%s",Path,fib->fib_FileName);
               if (fib->fib_DirEntryType>0) sprintf(rec.Size,"%s","DIR");
                  else sprintf(rec.Size,"%d",fib->fib_Size);
               sprintf(rec.CSize,"");
               sprintf(rec.Date,"%s %s",datebuffer,timebuffer);
            
               DoMethod(SelAdd_List,MUIM_NList_InsertSingle,&rec, Position);
            }
         }
      }   
      UnLock(BaseDirLock);
   }
   set(SelAdd_List,MUIA_NList_Quiet,FALSE);
}

   
/*----------------------------------------------------------------------------*/
/*    char *getfilename(Object *win, char *title, BOOL save,                  */
/*                       BOOL drawers, char *pattern, char *inidrawer)        */
/*    open ASL FileRequester and get selection                		      */
/*----------------------------------------------------------------------------*/
char *getfilename(Object *win, char *title, BOOL save, BOOL drawers, char *pattern, char *inidrawer)
{
   char inipath[256], *eip;
   static char buf[1024];
   struct FileRequester *req;
   struct Window *w;
   Object *app = (Object *)XGET(win,MUIA_ApplicationObject);
   char *res = NULL;
   int x;

   strcpy(inipath,inidrawer);
   eip = PathPart(inipath);
   eip[0]='\0';
   
   strncpy(buf,"",1024);
   res = buf;
   get(win,MUIA_Window_Window,&w);

   if(req=MUI_AllocAslRequestTags(ASL_FileRequest,
      ASLFR_Window, w,
      ASLFR_TitleText, title,
      ASLFR_InitialPattern , pattern,
      ASLFR_InitialDrawer  , inipath,
      ASLFR_DoSaveMode     , save,
      ASLFR_DoMultiSelect  , FALSE,
      ASLFR_DrawersOnly    , drawers,
      ASLFR_SetSortDrawers , ASLFRSORTDRAWERS_First,
      ASLFR_DoPatterns     , TRUE,
      ASLFR_RejectIcons    , TRUE,
      ASLFR_UserData       , app,
      TAG_DONE))
   {
      set(app,MUIA_Application_Sleep,TRUE);
      if (MUI_AslRequestTags(req,TAG_DONE))
      {
         res = buf;
         stccpy(buf,req->fr_Drawer,sizeof(buf));
         if(!drawers)
            if (*req->fr_Drawer) AddPart(buf,req->fr_File,sizeof(buf));
	    else strcat(buf,req->fr_File);
      }
      MUI_FreeAslRequest(req);
      set(app,MUIA_Application_Sleep,FALSE);
   }
   return(res);
}
